<?php

namespace App\Models;

class Warehouse extends Eloquent {

	protected $table = 'warehouses';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'email', 'password', 'address', 'latitude', 'longitude', 'warehouse_data', 'status', 'city_id');
	protected $hidden = array('password');

	public function admins()
	{
		return $this->hasMany('Admin');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

}