<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Session extends Model 
{

    protected $table = 'sessions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company()
    {
        return $this->belongsTo('Company', 'fk_company_id');
    }

    public function tasks()
    {
        return $this->hasMany('SessionTask');
    }

    public function receiversRepresentatives()
    {
        return $this->hasMany('Representative');
    }

    public function receiversUsers()
    {
        return $this->hasMany('User');
    }

}