<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Place extends Model 
{

    protected $table = 'places';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company()
    {
        return $this->belongsTo('Company', 'fk_company_id');
    }

    public function type()
    {
        return $this->belongsTo('PlaceType', 'fk_place_type_id');
    }

    public function address()
    {
        return $this->belongsTo('Address', 'fk_address_id');
    }

    public function users()
    {
        return $this->hasMany('User');
    }

    public function representatives()
    {
        return $this->hasMany('Representative');
    }

}