<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSignalsTable extends Migration {

	public function up()
	{
		Schema::create('signals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('message', 600)->nullable();
			$table->string('term', 100);
			$table->string('pair_of_coins', 100);
			$table->string('platforms', 200);
			$table->string('risk_index', 300);
			$table->string('stop_loss', 100);
			$table->integer('id_group');
			$table->string('coin', 200);
			$table->string('robot', 120)->nullable();
			$table->string('timeframe', 10)->nullable();
			$table->string('ata', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('signals');
	}
}