<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotesTable extends Migration {

	public function up()
	{
		Schema::create('notes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('area_id')->unsigned();
			$table->integer('type_id')->unsigned();
			$table->integer('priority_id')->unsigned();
			$table->string('violation_code', 50)->nullable();
			$table->string('longitude', 255);
			$table->string('latitude', 255);
			$table->text('comment')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('direction_id')->unsigned();
			$table->string('cause', 150)->nullable();
			$table->enum('status', array('opened', 'qualified', 'unqualified', 'resolved', 'resolve_accepted', 'resolve_reject', 'resolve_confirmed', 'closed_with_notes', 'closed'));
			$table->boolean('redirect')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('notes');
	}
}