<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->integer('hotel_id');
			$table->integer('payment_id');
			$table->integer('booking_status_id');
			$table->integer('payment_status_id');
			$table->text('description')->nullable();
			$table->decimal('price');
			$table->decimal('vat');
			$table->datetime('check_in')->nullable();
			$table->datetime('check_out')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}