<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHotelsTable extends Migration {

	public function up()
	{
		Schema::create('hotels', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 250);
			$table->string('address', 250);
			$table->integer('ward_id')->nullable();
			$table->integer('district_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->text('description')->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('mobile', 20)->nullable();
			$table->string('email', 250);
			$table->float('lattitude');
			$table->float('longitude');
			$table->integer('rating');
			$table->integer('rate_count');
		});
	}

	public function down()
	{
		Schema::drop('hotels');
	}
}