<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomsTable extends Migration {

	public function up()
	{
		Schema::create('rooms', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('hotel_id')->unsigned();
			$table->integer('room_type_id');
			$table->integer('room_status_id');
			$table->integer('max_adults');
			$table->integer('max_children');
			$table->integer('max_extra_beds');
			$table->integer('number_of_rooms');
			$table->integer('beds');
			$table->integer('bathrooms');
			$table->decimal('room_area');
			$table->decimal('price');
			$table->decimal('extra_bed_charge');
		});
	}

	public function down()
	{
		Schema::drop('rooms');
	}
}