<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRewardHistoryTable extends Migration {

	public function up()
	{
		Schema::create('reward_history', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->string('pay_from');
			$table->string('pay_to')->index();
			$table->integer('amount')->index();
			$table->datetime('created_date');
			$table->string('description');
			$table->timestamp('updated_at');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reward_history');
	}
}