<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContatosTable extends Migration {

	public function up()
	{
		Schema::create('contatos', function(Blueprint $table) {
			$table->increments('contatos_id');
			$table->string('cep', 16)->nullable();
			$table->string('estado', 72)->nullable();
			$table->string('cidade', 60)->nullable();
			$table->string('bairro', 72)->nullable();
			$table->string('logradouro', 125)->nullable();
			$table->string('numero', 7)->nullable();
			$table->string('complemento', 50)->nullable();
			$table->string('telefone', 11)->nullable();
			$table->string('celular', 11)->nullable();
			$table->string('email', 60)->nullable();
			$table->string('facebook', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contatos');
	}
}