<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfessoresTable extends Migration {

	public function up()
	{
		Schema::create('professores', function(Blueprint $table) {
			$table->increments('professores_id');
			$table->integer('contatos_id')->unsigned();
			$table->string('nome', 100);
			$table->string('cpf', 20)->unique();
			$table->string('rg', 20)->unique();
			$table->boolean('ativo')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('professores');
	}
}