<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Clientes extends Eloquent {

	protected $table = 'clientes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('nome', 'email', 'cpf', 'rg', 'sexo', 'data_nascimento', 'pai', 'mae', 'aceitar_email', 'observacao', 'ativo');

	public function empresa()
	{
		return $this->belongsTo('Empresas', 'empresas_id');
	}

	public function contato()
	{
		return $this->hasOne('Contatos', 'contatos_id');
	}

	public function matriculas()
	{
		return $this->hasMany('Matriculas', 'matriculas_id');
	}

	public function cupons()
	{
		return $this->hasMany('Cupons', 'cupons_id');
	}

}