<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Matriculas extends Eloquent {

	protected $table = 'matriculas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('termo', 'observacao', 'ativo');

	public function cliente()
	{
		return $this->belongsTo('Clientes', 'clientes_id');
	}

	public function turma()
	{
		return $this->belongsTo('Turmas', 'turmas_id');
	}

	public function frequencias()
	{
		return $this->hasMany('Frequencias', 'frequencias_id');
	}

}