<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('paniers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visuels', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adresseLivraison_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adresseFacturation_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_capacity', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_capacity', function(Blueprint $table) {
			$table->foreign('capacity_id')->references('id')->on('capacities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('paniers', function(Blueprint $table) {
			$table->dropForeign('paniers_user_id_foreign');
		});
		Schema::table('visuels', function(Blueprint $table) {
			$table->dropForeign('visuels_product_id_foreign');
		});
		Schema::table('adresseLivraison_user', function(Blueprint $table) {
			$table->dropForeign('adresseLivraison_user_user_id_foreign');
		});
		Schema::table('adresseFacturation_user', function(Blueprint $table) {
			$table->dropForeign('adresseFacturation_user_user_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_product_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_category_id_foreign');
		});
		Schema::table('product_capacity', function(Blueprint $table) {
			$table->dropForeign('product_capacity_product_id_foreign');
		});
		Schema::table('product_capacity', function(Blueprint $table) {
			$table->dropForeign('product_capacity_capacity_id_foreign');
		});
	}
}