<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDrugsTable extends Migration {

	public function up()
	{
		Schema::create('drugs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->enum('type', array('Drink', 'Capsules', 'injection'));
			$table->date('Production_date');
			$table->date('Expiry_date');
			$table->string('Arrival_date');
			$table->string('Price_Sales');
			$table->string('Price_Sales_unit');
			$table->string('Cost');
			$table->string('Quantity');
			$table->enum('Payment', array('Cash', 'Ontheaccount', 'halfcash'));
			$table->string('Total_Payment');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('drugs');
	}
}