<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->mediumInteger('union_id');
			$table->mediumInteger('category_id');
			$table->mediumInteger('farmer_id');
			$table->mediumInteger('unit_id');
			$table->integer('quantity');
			$table->double('price');
			$table->mediumText('loadin_point');
			$table->timestamps();
			$table->bigInteger('created_by');
			$table->string('created_by_ip', 15);
			$table->bigInteger('updated_by')->nullable();
			$table->string('updated_by_ip', 15)->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}