<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Capitals extends Model 
{

    protected $table = 'capitals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('amount', 'site_id', 'employee_id');

    public function site()
    {
        return $this->belongsTo('Sites', 'site_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employees', 'employee_id');
    }

}