<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employees extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'position', 'daily_salary', 'national_id', 'mobile', 'job_number', 'house_allowance', 'site_id');

    public function site()
    {
        return $this->belongsTo('Sites', 'site_id');
    }

}