<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Income extends Model 
{

    protected $table = 'income';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('site_id', 'name', 'amount', 'note', 'check_number', 'check_date');

    public function site()
    {
        return $this->belongsTo('Sites', 'site_id');
    }

}