<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PartnerExpenses extends Model 
{

    protected $table = 'partnerexpenses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('site_id', 'amount', 'date', 'note', 'expense_item', 'type', 'partner_id');

    public function site()
    {
        return $this->belongsTo('Sites', 'site_id');
    }

    public function partner()
    {
        return $this->belongsTo('Partners', 'partner_id');
    }

}