<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCapitalReportsTable extends Migration {

	public function up()
	{
		Schema::create('capital_reports', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('expense_item');
			$table->double('amount');
			$table->datetime('date');
			$table->text('notes')->nullable();
			$table->integer('capital_id');
		});
	}

	public function down()
	{
		Schema::drop('capital_reports');
	}
}