<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStorestocksTable extends Migration {

	public function up()
	{
		Schema::create('storestocks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('store_id');
			$table->integer('item_id')->nullable();
			$table->integer('vendor_id');
			$table->integer('quantity');
			$table->double('amount');
			$table->date('date');
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('storestocks');
	}
}