<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpensesTable extends Migration {

	public function up()
	{
		Schema::create('expenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('site_id');
			$table->double('amount');
			$table->datetime('date');
			$table->text('note')->nullable();
			$table->enum('type', array('capital', 'consumed'));
			$table->string('expense_item');
		});
	}

	public function down()
	{
		Schema::drop('expenses');
	}
}