<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CapitalReports extends Eloquent {

	protected $table = 'capital_reports';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('expense_item', 'amount', 'date', 'notes', 'capital_id');

	public function capital()
	{
		return $this->belongsTo('Capitals', 'capital_id');
	}

}