<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;

class UniversetyOrder extends Model 
{

    protected $table = 'universety_orders';
    public $timestamps = true;
    protected $fillable = array('user_id', 'level', 'subject_id', 'course_type', 'start_date_id', 'tracking_number', 'status', 'advisor_id');

    public function start_date()
    {
        return $this->belongsTo('StartDate', 'start_date_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}