<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccommodationsTable extends Migration {

	public function up()
	{
		Schema::create('accommodations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->mediumText('title');
			$table->longText('description')->nullable();
			$table->smallInteger('rooms_number');
			$table->integer('city_id');
			$table->double('price');
			$table->tinyInteger('status')->default('0');
			$table->tinyInteger('per')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('accommodations');
	}
}