<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sayfa_dil', function(Blueprint $table) {
			$table->foreign('dil_id')->references('id')->on('dil')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sayfa_dil', function(Blueprint $table) {
			$table->foreign('sayfa_id')->references('id')->on('sayfa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sayfa_dil', function(Blueprint $table) {
			$table->dropForeign('sayfa_dil_dil_id_foreign');
		});
		Schema::table('sayfa_dil', function(Blueprint $table) {
			$table->dropForeign('sayfa_dil_sayfa_id_foreign');
		});
	}
}