<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashOutsTable extends Migration {

	public function up()
	{
		Schema::create('cash_outs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('cash_back_id');
			$table->integer('payment_type_id')->unsigned()->nullable();
			$table->enum('status', array('pending', 'progress', 'done'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cash_outs');
	}
}