<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LayerType extends Model 
{

    protected $table = 'layer_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'child_level');
    protected $visible = array('name', 'child_level');

    public function layers()
    {
        return $this->hasMany('App\Layer');
    }

}