<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Layer extends Eloquent {

	protected $table = 'layers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'data', 'layer_type_id', 'parent_layer_id', 'price');
	protected $visible = array('name', 'data', 'layer_type_id', 'parent_layer_id', 'price');

	public function layerType()
	{
		return $this->belongsTo('App\LayerType');
	}

}