<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParticipationsTable extends Migration {

	public function up()
	{
		Schema::create('participations', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->string('draw_id', 100);
			$table->integer('purchased_slot_count');
			$table->double('unit_slot_price', 20,2);
			$table->double('grand_slot_price', 20,2);
			$table->integer('slot_start');
			$table->integer('user_id');
			$table->string('product_id');
			$table->timestamps();
			$table->string('address_id');
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('participations');
	}
}