<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUsersTable extends Migration {

	public function up()
	{
		Schema::create('admin_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 50);
			$table->string('email', 100);
			$table->datetime('email_verified_at')->nullable();
			$table->string('password', 500);
			$table->string('image', 100)->nullable();
			$table->string('role_id', 20);
			$table->string('is_active', 5);
			$table->string('remember_token', 250)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('admin_users');
	}
}