<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone_number', 250);
			$table->string('name', 100)->nullable();
			$table->string('email', 250);
			$table->datetime('email_verified_at')->nullable();
			$table->string('otp', 10);
			$table->string('device_token', 500);
			$table->string('device_type', 10);
			$table->string('is_active', 10);
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}