<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('product_name', 150);
			$table->string('product_title', 150);
			$table->string('product_code', 50);
			$table->integer('category_id');
			$table->string('gst', 20);
			$table->string('product_description', 500)->nullable();
			$table->double('product_price', 20,2);
			$table->integer('stock');
			$table->softDeletes();
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}