<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 100);
			$table->string('slug', 250);
			$table->string('is_active', 20);
			$table->string('description', 300)->nullable();
			$table->softDeletes();
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}