<?php

namespace Module/Admin/Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Wallet extends Eloquent {

	protected $table = 'wallets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function wallet_credit_relation()
	{
		return $this->hasMany('WalletCredits', 'wallet_id');
	}

	public function wallet_debit_relation()
	{
		return $this->hasOne('WalletDebits', 'wallet_id');
	}

}