<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlansTable extends Migration {

	public function up()
	{
		Schema::create('plans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('image', 100)->default('default.png');
			$table->string('name', 100);
			$table->integer('duration');
			$table->double('price', 8,2)->default('0.0');
		});
	}

	public function down()
	{
		Schema::drop('plans');
	}
}