<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderReplyTable extends Migration {

	public function up()
	{
		Schema::create('order_reply', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->nullable();
			$table->integer('item_id')->nullable();
			$table->integer('store_id')->nullable();
			$table->double('price')->nullable();
			$table->boolean('available')->nullable();
			$table->boolean('negotiable')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_reply');
	}
}