<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderReply extends Eloquent {

	protected $table = 'order_reply';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'item_id', 'store_id', 'price', 'available', 'negotiable');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function item()
	{
		return $this->belongsTo('OrderItem', 'item_id');
	}

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

}