<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreBrand extends Eloquent {

	protected $table = 'store_brand';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id', 'brand_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function brand()
	{
		return $this->belongsTo('Brand', 'brand_id');
	}

}