<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreTable extends Migration {

	public function up()
	{
		Schema::create('store', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('password')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->string('city_id')->nullable();
			$table->integer('from_year')->nullable();
			$table->integer('to_year')->nullable();
			$table->string('whats_up')->nullable();
			$table->double('longitude')->nullable();
			$table->double('latitude')->nullable();
			$table->string('address_en')->nullable();
			$table->string('address_ar')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('country_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('store');
	}
}