<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('phone', 255);
			$table->decimal('latitude', 10,8);
			$table->decimal('longitude', 10,8);
			$table->float('cost');
			$table->string('location', 255);
			$table->time('duration');
			$table->bigInteger('doctor_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}