<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankDoctorTable extends Migration {

	public function up()
	{
		Schema::create('bank_doctor', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('num');
			$table->bigInteger('doctor_id')->unsigned()->nullable();
			$table->bigInteger('bank_id')->unsigned()->nullable();
			$table->string('beneficiary_name', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bank_doctor');
	}
}