<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('doctor_id')->unsigned();
			$table->bigInteger('patient_id')->unsigned();
			$table->text('content');
			$table->enum('type', array('online_concultation', 'clinical_concultation', 'at_home'));
			$table->bigInteger('clinic_id')->unsigned();
			$table->date('date');
			$table->time('time');
			$table->string('patient_name', 255);
			$table->decimal('longitude', 10,8);
			$table->decimal('latitude', 10,8);
			$table->text('location');
			$table->enum('status', array('accept', 'finished', 'rejected', 'cancel', 'reschedule', 'pending'));
			$table->bigInteger('booking_type_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
			$table->bigInteger('shift_id')->unsigned();
			$table->tinyInteger('is_review')->default('0');
			$table->tinyInteger('next_review')->default('0');
			$table->date('review_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}