<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkingHourSettingsTable extends Migration {

	public function up()
	{
		Schema::create('working_hour_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('hour')->nullable();
			$table->string('sentence_en', 255);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('shift_id')->unsigned()->nullable();
			$table->string('sentence_ar', 255);
			$table->string('sentence_ro', 255);
		});
	}

	public function down()
	{
		Schema::drop('working_hour_settings');
	}
}