<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('rattings', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rattings', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('booking_type_id')->references('id')->on('bookings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('shift_id')->references('id')->on('shifts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_specialty', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('doctor_specialty', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lisences', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('working_hour_settings', function(Blueprint $table) {
			$table->foreign('shift_id')->references('id')->on('shifts')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('place_types', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('place_images', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->foreign('setting_id')->references('id')->on('settings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->foreign('days_of_week_id')->references('id')->on('days_of_week')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medical_examinations', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('dosage_id')->references('id')->on('dosages')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('prescription_validation_id')->references('id')->on('prescription_validation')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('booking_images', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('medical_analysis', function(Blueprint $table) {
			$table->foreign('medical_analysis_type_id')->references('id')->on('medical_analysis_types')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('medical_analysis', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('medical_x_rays', function(Blueprint $table) {
			$table->foreign('medical_x_ray_type_id')->references('id')->on('medical_x_ray_types')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('medical_x_rays', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('doctor_insurance_companies', function(Blueprint $table) {
			$table->foreign('insurance_company_id')->references('id')->on('insurance_companies')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('doctor_insurance_companies', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('doctors_doctor_general_titles', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('doctors_doctor_general_titles', function(Blueprint $table) {
			$table->foreign('doctor_general_tiltle_id')->references('id')->on('doctor_general_titles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('assistants', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('bank_doctor', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('bank_doctor', function(Blueprint $table) {
			$table->foreign('bank_id')->references('timestamps')->on('banks')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('rattings', function(Blueprint $table) {
			$table->dropForeign('rattings_doctor_id_foreign');
		});
		Schema::table('rattings', function(Blueprint $table) {
			$table->dropForeign('rattings_patient_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_doctor_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_patient_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_booking_type_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_shift_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_doctor_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_patient_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_payment_method_id_foreign');
		});
		Schema::table('doctor_specialty', function(Blueprint $table) {
			$table->dropForeign('doctor_specialty_doctor_id_foreign');
		});
		Schema::table('doctor_specialty', function(Blueprint $table) {
			$table->dropForeign('doctor_specialty_specialty_id_foreign');
		});
		Schema::table('lisences', function(Blueprint $table) {
			$table->dropForeign('lisences_doctor_id_foreign');
		});
		Schema::table('working_hour_settings', function(Blueprint $table) {
			$table->dropForeign('working_hour_settings_shift_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_doctor_id_foreign');
		});
		Schema::table('place_types', function(Blueprint $table) {
			$table->dropForeign('place_types_place_id_foreign');
		});
		Schema::table('place_images', function(Blueprint $table) {
			$table->dropForeign('place_images_place_id_foreign');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->dropForeign('shifts_setting_id_foreign');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->dropForeign('shifts_days_of_week_id_foreign');
		});
		Schema::table('shifts', function(Blueprint $table) {
			$table->dropForeign('shifts_place_id_foreign');
		});
		Schema::table('medical_examinations', function(Blueprint $table) {
			$table->dropForeign('medical_examinations_booking_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_dosage_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_prescription_validation_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_booking_id_foreign');
		});
		Schema::table('booking_images', function(Blueprint $table) {
			$table->dropForeign('booking_images_booking_id_foreign');
		});
		Schema::table('medical_analysis', function(Blueprint $table) {
			$table->dropForeign('medical_analysis_medical_analysis_type_id_foreign');
		});
		Schema::table('medical_analysis', function(Blueprint $table) {
			$table->dropForeign('medical_analysis_booking_id_foreign');
		});
		Schema::table('medical_x_rays', function(Blueprint $table) {
			$table->dropForeign('medical_x_rays_medical_x_ray_type_id_foreign');
		});
		Schema::table('medical_x_rays', function(Blueprint $table) {
			$table->dropForeign('medical_x_rays_booking_id_foreign');
		});
		Schema::table('doctor_insurance_companies', function(Blueprint $table) {
			$table->dropForeign('doctor_insurance_companies_insurance_company_id_foreign');
		});
		Schema::table('doctor_insurance_companies', function(Blueprint $table) {
			$table->dropForeign('doctor_insurance_companies_doctor_id_foreign');
		});
		Schema::table('doctors_doctor_general_titles', function(Blueprint $table) {
			$table->dropForeign('doctors_doctor_general_titles_doctor_id_foreign');
		});
		Schema::table('doctors_doctor_general_titles', function(Blueprint $table) {
			$table->dropForeign('doctors_doctor_general_titles_doctor_general_tiltle_id_foreign');
		});
		Schema::table('assistants', function(Blueprint $table) {
			$table->dropForeign('assistants_doctor_id_foreign');
		});
		Schema::table('bank_doctor', function(Blueprint $table) {
			$table->dropForeign('bank_doctor_doctor_id_foreign');
		});
		Schema::table('bank_doctor', function(Blueprint $table) {
			$table->dropForeign('bank_doctor_bank_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_doctor_id_foreign');
		});
	}
}