<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Patient extends Eloquent {

	protected $table = 'patients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'gender', 'd_o_b', 'email', 'password', 'latitude', 'longitude', 'pin_code', 'google_id', 'fb_id', 'email_verified_at', 'terms', 'country_id', 'softDeletes');

	public function rattings()
	{
		return $this->hasMany('Doctor');
	}

	public function bookings()
	{
		return $this->hasMany('Doctor');
	}

	public function payment()
	{
		return $this->belongsTo('Payment');
	}

	public function offers()
	{
		return $this->morphToMany('Offer', 'offerable');
	}

}