<?php

namespace App/Models/;

class Place extends Eloquent {

	protected $table = 'places';
	public $timestamps = true;
	protected $fillable = array('phone', 'latitude', 'longitude', 'cost', 'location', 'duration', 'doctor_id');

	public function images()
	{
		return $this->hasMany('PlaceImage');
	}

	public function placeType()
	{
		return $this->belongsTo('PlaceType');
	}

	public function shifts()
	{
		return $this->hasMany('Shift');
	}

	public function doctor()
	{
		return $this->belongsTo('Doctor');
	}

}