<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->text('title');
			$table->string('category');
			$table->text('description');
			$table->string('image');
			$table->string('delivery_time');
			$table->string('features');
			$table->string('price');
			$table->string('supplier')->nullable();
			$table->string('external_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}