<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpertsTable extends Migration {

	public function up()
	{
		Schema::create('experts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid', 80)->unique();
			$table->integer('user_id');
			$table->string('currency_code', 5);
			$table->string('first_name', 50);
			$table->string('last_name');
			$table->mediumText('bio')->nullable();
			$table->string('image', 500)->nullable();
			$table->enum('status', array('online', 'offline', 'calling'));
			$table->boolean('active')->default(0);
			$table->boolean('chat_enabled')->default(0);
			$table->decimal('chat_cost', 15,0)->default('0');
			$table->boolean('call_enabled')->default(0);
			$table->decimal('call_cost', 15,0)->default('0');
			$table->boolean('video_enable')->default(0);
			$table->decimal('video_cost', 15,0)->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('experts');
	}
}